/************************************************************************
*                                                                                                                                        
*    Test du module Pmod USBUART                                          
*                                                                    
*************************************************************************
* Description:  Pmod_USBUART                                               
* Une carte Arduino + module Pmod USBUART échange des chaînes de caractères
* avec le logiciel ComTools depuis un port USB et le moniteur série.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod USBUART (Le cavalier JP1 est positionné sur LCL-VCC).
*        3. Logiciel ComTools (à télécharger https://www.sonelec-musique.com/logiciels_freewares_comtools.html)
*        ATTENTION, il faut brancher le module avant de lancer le logiciel
************************************************************************/
#define RX 9                                      // affectation des broches 
#define TX 8

#include <SoftwareSerial.h>                       // appel de la bibliothèque
SoftwareSerial USB(RX, TX);                       // création de l'objet USB

void setup() 
{
 Serial.begin(9600);                             // initialisation de la liaison série
 USB.begin(9600);                                // initialisation de la liaison série USB  
 Serial.println("Test du module Pmod USB-UART"); // écriture dans le moniteur série
 USB.println("Connexion etablie");               // écriture sur le logiciel ComTools
}

void loop() 
{ 
  if (USB.available())                           // si une donnée est présente sur le port USB
  {
    Serial.write(USB.read());                    // écriture de cette donnée dans le moniteur série
  }
  if (Serial.available())                        // si une donnée est présente sur moniteur série
  {
    USB.write(Serial.read());                    // écriture de cette donnée dans le logiciel               
  }
}

