/************************************************************************
*                                                                                                                                        
*    Test du module Pmod thermomètre                                            
*                                                                    
*************************************************************************
* Description:  Pmod_TMP3                                               
* La température ambiante (en °F et °C) est affichée dans le moniteur série .
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod TMP3 (position des cavaliers JP1, JP2 et JP3  sur GND)
*        
************************************************************************/

#include <Wire.h>                                  // appel de la bibliothèque 
#define TCN75A_Adresse 0x48                        // adresse I2C du module Pmod TMP3
 
int MSB;
int LSB;
int valeur;
float temperature;

void setup()
{
  Serial.begin(9600);                              // initialisation de la liaison série 
  Wire.begin();                                    // initialisation de la liaison I2C
  Init_TCN75A();                                   // initialisation du module Pmod TMP3
}
 
void loop()
{
  Wire.beginTransmission(TCN75A_Adresse);         // lancement de la mesure
  Wire.endTransmission();
  delay(10);
  Wire.requestFrom(TCN75A_Adresse, 2);            // récupération des deux octets MSB et LSB
  if(Wire.available() <=2)
  {    
    MSB = Wire.read();
    LSB = Wire.read();
  }
  valeur=LSB |(MSB<<8) ;
  valeur=valeur>> 4;
  temperature=valeur/16.00;
  Serial.print("MSB=");                           // affichage dans le moniteur série
  Serial.println(MSB);
  Serial.print("LSB=");
  Serial.println(LSB);
  Serial.print("Valeur=");
  Serial.println(valeur);
  Serial.print("Température en F = ");
  Serial.print(temperature*9/5 + 32,2);
  Serial.print("   ");
  Serial.print("Température en C = ");
  Serial.println(temperature, 2); 
  delay(1000);
}

// Initialisation du module Pmod TMP3
void Init_TCN75A(void)
{
  Wire.beginTransmission(TCN75A_Adresse);
  Wire.write(0x01);                              
  Wire.write(0x60);                              
  Wire.endTransmission();
  Wire.beginTransmission(TCN75A_Adresse);
  Wire.write(0x00);                              
  Wire.endTransmission();
}
