/************************************************************************
*                                                                                                                                        
*    Test du module Pmod thermostat\thermomètre                                            
*                                                                    
*************************************************************************
* Description:  Pmod_TMP2                                               
* La température ambiante est affiché sur le moniteur série et 
* sur un afficheur LCD série .
* 
* 
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod TMP2 
*        3. Module Pmod CLS
*        
************************************************************************/

#include <Wire.h>                                  // appel de la bibliothèque 
#define ADT7420_Adresse 0x4B                       // adresse I2C du module Pmod TMP2

//Déclaration d'un port série
#include <SoftwareSerial.h>  
SoftwareSerial lcd(2,3); // RX, TX 

int MSB;
int LSB;
int valeur;
float temperature;

void setup()
{
  Serial.begin(9600);                              // initialisation de la liaison série 
  Wire.begin();                                    // initialisation de la liaison I2C
  Init_ADT7420();                                  // initialisation du module Pmod AD2
  lcd.begin(9600);                                 // initialisation de la liaison série de l'afficheur
  lcd.write("\x1b[j");                             // effacement de l'afficheur
  lcd.write("\x1b[0h");                            // configuration de l'afficheur en mode écriture du message sur deux lignes
}
 
void loop()
{
  Wire.beginTransmission(ADT7420_Adresse);         // lancement de la mesure
  Wire.endTransmission();
  delay(10);
  Wire.requestFrom(ADT7420_Adresse, 2);            // récupération des deux octets MSB et LSB
  if(Wire.available() <=2)
  {    
    MSB = Wire.read();
    LSB = Wire.read();
  }
  valeur=(MSB<<8)|LSB ;
  if (((valeur>>15)&1)==0)                        // si la temperature est positive
  {
    temperature=valeur/128.0;
  }
  else                                            // si la temperature est négative
  {
    temperature=(valeur-65535)/128.0;
  }
  Serial.print("MSB=");                           // affichage dans le moniteur série
  Serial.println(MSB);
  Serial.print("LSB=");
  Serial.println(LSB);
  Serial.print("Valeur=");
  Serial.println(valeur);
  Serial.print("Temperature=");
  Serial.println(temperature);
  lcd.write("\x1b[j");                           // effacement de l'afficheur 
  lcd.print("Temperature:");                     // écriture sur l'afficheur
  lcd.write("\x1b[1;0H");                        // positionnement du curseur 2nde ligne 1ère colonne
  lcd.print(temperature);
  lcd.print((char)223);
  lcd.print("c");                              
  delay(1000);
}

// Initialisation du module Pmod TMP2
void Init_ADT7420(void)
{
// configuration de l'ADT7420 en mode 16 bit
  Wire.beginTransmission(ADT7420_Adresse);
  Wire.write(0x03);                             
  Wire.write(0x80);                              
  Wire.endTransmission();
}
