/************************************************************************
*                                                                                                                                        
*    Test du module Pmod thermocouple type K                                            
*                                                                    
*************************************************************************
* Description:  Pmod_TC1                                               
* La valeur de la température est affichée sur le moniteur série.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod TC1 (télécharger la bibliothèque 
*        https://github.com/adafruit/Adafruit-MAX31855-library)
*        3. Module Adafruit TXB0108
*        
* Câblage           
*        Module<----------> TXB0108 <-----------> Arduino
*        J1 broche 6                               3.3 V
*        J1 broche 5                               GND
*        J1 broche 4                               13
*        J1 broche 3                               12  
*        J1 broche 1                               10
************************************************************************/
// affectation des broches
#define CS 10 
#define MISO 12  
#define SCLK 13                 

// appel des bibliothèques
#include <SPI.h>
#include "Adafruit_MAX31855.h"

Adafruit_MAX31855 Temp(SCLK, CS, MISO);  // création de l'objet


void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  delay(500);
}
 
void loop()
{
 Serial.print("Temperature en C = "); 
 Serial.println(Temp.readCelsius());    // acquisition de la température en degré Celcius
 Serial.print("Temperature en F = ");
 Serial.println(Temp.readFarenheit());  // acquisition de la température en degré Fahrenheit
 delay(1000);
}  
