/************************************************************************
*                                                                                                                                        
*    Test du module Pmod 4 interrupteurs                                           
*                                                                    
*************************************************************************
* Description:  Pmod_SWT                                               
* L'état des interrupteurs est affiché sur un module LED 
* et le nombre décimal équivalent dans le moniteur série
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod LED
*        3. Module Pmod SWT
*        
************************************************************************/
// Affectation des broches
#define LED_0 2
#define LED_1 3
#define LED_2 4
#define LED_3 5
#define SWT_1 6
#define SWT_2 7
#define SWT_3 8
#define SWT_4 9

boolean inter_1;
boolean inter_2;
boolean inter_3;
boolean inter_4;
int nombre;

void setup()
{
  Serial.begin(9600);                      // initialisation du moniteur série
  for (int i=2; i<=5; i++)                 // configuration des broches 2 à 5 en sortie
  {
     pinMode(i,OUTPUT);
  } 
  for (int i=6; i<=9; i++)                 // configuration des broches 6 à 9 en entrée
  {
     pinMode(i,INPUT);
  } 
}

void loop()
{
 inter_1=digitalRead(SWT_1);               // lecture de l'interrupteur SW1
 digitalWrite(LED_0,inter_1);              // commande de la led LED0 en fonction de l'état de l'interrupteur SW1
 inter_2=digitalRead(SWT_2);
 digitalWrite(LED_1,inter_2); 
 inter_3=digitalRead(SWT_3);
 digitalWrite(LED_2,inter_3); 
 inter_4=digitalRead(SWT_4);
 digitalWrite(LED_3,inter_4);
 nombre=inter_1+inter_2*2+inter_3*4+inter_4*8;  // conversion binaire-décimal
 Serial.print("Le nombre decimal est egal à "); // affichage dans le moniteur série
 Serial.println(nombre);
}


