/************************************************************************
*                                                                                                                                        
*    Test du module Pmod pilotage de moteur pas à pas                                           
*                                                                    
*************************************************************************
* Description:  Pmod_STEP                                               
* Le moteur fait un tour complet dans un sens puis revient à sa position 
* d'origine
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod STEP (positionner le cavalier JP1 en position 2-3)
*        
************************************************************************/
#include <Stepper.h>                             // appel de la bibliothèque

#define enroulement_1 2                          // affectation des broches
#define enroulement_2 3
#define enroulement_3 4
#define enroulement_4 5

const int nombre_pas=2048;                        // nombre de pas du moteur

Stepper moteur(nombre_pas, enroulement_1, enroulement_2, enroulement_3, enroulement_4);    // création de l'objet moteur

void setup()   
{
Serial.begin(9600);
moteur.setSpeed(10);                              // initialisation la vitesse de rotation du moteur en tour par minute
pinMode(enroulement_1, OUTPUT);                   // configuration des broches en sortie
pinMode(enroulement_2, OUTPUT);       
pinMode(enroulement_3, OUTPUT);     
pinMode(enroulement_4, OUTPUT);  
}

void loop()
{
Serial.println("Sens 1");
for (int i=1; i<=nombre_pas; i++)                 // boucle avance du moteur en fonction du nombre de pas
{
  moteur.step(1);                                 // un pas en sens positif
/* Temporisation utile pour voir le déroulement des séquences sur les led du module. 
   Diminuer la temporisation pour augmenter la vitesse de rotation du moteur.*/
  delay(100);                                    
}
Serial.println("Sens 2");
for (int i=1; i<=nombre_pas; i++)                 // boucle retour du moteur en fonction du nombre de pas
{   
  moteur.step(-1);                                // un pas en sens négatif
/* Temporisation utile pour voir le déroulement des séquences sur les led du module. 
   Diminuer la temporisation pour augmenter la vitesse de rotation du moteur.*/
  delay(100);                                    
}
}

