/************************************************************************
*                                                                                                                                        
*    Test du module Pmod relais statique                                        
*                                                                    
*************************************************************************
* Description:  Pmod_SSR                                                
* Une charge est commandée depuis le moniteur série (0=OFF et 1=ON)
* et via le module pouvant commuter une puissance importante.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod relais statique
* 
************************************************************************/
#define relais 2
char octetReception=0;               

void setup()
{
  Serial.begin(9600);                // initialisation du moniteur série
  pinMode(relais,OUTPUT);            // broche 2 configurée en sortie 
}

void loop()
{
 Serial.println("Relais actif:Taper 1 ou Relais inactif:Taper 0");
      
  while (Serial.available()==0);     // attente réception d’un octet
  {  
   octetReception=Serial.read();     // lecture de l'octet reçu et stockage dans la variable
   switch (octetReception)           
   { 
    case '0':                        // cas 0
      {
      digitalWrite(relais,LOW);      // relais inactif
      Serial.println("Relais inactif");
      Serial.println();
      break;
      }
      
    case '1': // cas 1
      {
      digitalWrite(relais,HIGH);      // relais actif
      Serial.println("Relais inactif");
      Serial.println();
      break;
      }
     
    default: // cas par défaut
      {
    Serial.println("Commande non reconnue");
      }
  } 
 }
}


