/************************************************************************
*                                                                                                                                        
*    Test du module Pmod double afficheur                                           
*                                                                    
*************************************************************************
* Description:  Pmod_SSD                                                
* Un compteur s'incrémente toutes les secondes.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod SSD
*        
************************************************************************/

byte ledPin[8]={2, 3, 4, 5, 6, 7, 8, 9};                  // numéros de broches de l'Arduino 
byte code[10]={63,6,91,79,102,109,124,7,127,103};         // code des chiffres 0 à 9

int unite=0;
int dizaine=0;
int duree;


void setup()      
{                
for (int i=0; i<=8; i++)                   // configuration des broches 2 à 9 en sortie
   {
   pinMode(ledPin[i], OUTPUT); 
   }
}

// Programme principal
void loop() 
{
  duree=millis() / 1000;                   // chronomètre
  dizaine=duree/10;                        // extraction des dizaines
  unite=duree%10;                          // extraction des unités
  if (duree>=100)                          // remise à 0 lorsque le compteur arrive à 99
  {
  dizaine=0;
  unite=0;
  }
  digitalWrite(9,LOW);                    // sélection de l'afficheur des unités
  afficher(code[unite]);                  // affichage des unités
  delay(10);
  digitalWrite(9,HIGH);                   // sélection de l'afficheur des dizaines
  afficher(code[dizaine]);                // affichage des dizaines
  delay(10);
}

void afficher(int x)                      // procédure codant le chiffre en 7 segments
{
 byte chiffre=x; 
 byte segment=0;
 for (int i=2; i<9; i++)
   {
      segment=chiffre&00000001;
      digitalWrite(i,segment);
      chiffre=chiffre>>1;
   }  
}
