/************************************************************************
*                                                                                                                                        
*    Test du module Pmod mémoire Flash PCM série                                            
*                                                                    
*************************************************************************
* Description:  Pmod_SF2                                               
* Une donnée est mémorisée à l'adresse spécifiée puis relue et affichée 
* dans le moniteur série.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod SF2 
*        3. Module Adafruit TXB0108
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

int i;
int adresse=0xFF;
int donnee=0x55;
byte recu[3];    
byte envoi[5];    

void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  SPI.begin();                          // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);           // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16); // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
  envoi[0] = adresse >> 16;
  envoi[1] = adresse >> 8;
  envoi[2] = adresse;
  envoi[3] = donnee;
  // validation écriture dans la mémoire
  digitalWrite(CS, LOW);               // activation de la ligne CS
  SPI.transfer(0x06);                  // validation écriture 
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS 
  // effacement complet la mémoire
  digitalWrite(CS, LOW);               // activation de la ligne CS
  SPI.transfer(0xC7);                  // effacement  
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS 
  // écriture d'une donnée à l'adresse spécifiée
  digitalWrite(CS, LOW);               // activation de la ligne CS
  SPI.transfer(0x02);                  // écriture d'une donnée à l'adresse
  for (i=0;i<4;i=i+1)                         
       {
       SPI.transfer(envoi[i]);         
       }
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS 
  digitalWrite(CS, LOW);               // activation de la ligne CS
  SPI.transfer(0x04);                  // blocage écriture 
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS 
  delay(1000);
  
}
 
void loop()
{
  digitalWrite(CS, LOW);               // activation de la ligne CS
  SPI.transfer(0x03);                  // lecture d'une donnée à l'adresse
  for (i=0;i<3;i=i+1)                         
       {
       SPI.transfer(envoi[i]);         
       }
  recu[0]=SPI.transfer(0);
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS
  Serial.println(recu[0],HEX);
}
