/************************************************************************
*                                                                                                                                        
*    Test du module Pmod lecteur carte SD                                            
*                                                                    
*************************************************************************
* Description:  Pmod_SD                                               
* Les tensions appliquées sur les entrées A0 et A1 sont enregistrées 
* dans un fichier de la carte SD.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod SD 
*        3. Module Adafruit TXB0108
*        
************************************************************************/

#define CS 10                                            // affectation de la broche CS

#include <SPI.h>                                         // appel des bibliothèques
#include <SD.h> 
int tension;

void setup()
{
  Serial.begin(9600);                                    // initialisation de la liaison série 
  Serial.println("Initialisation carte SD");
  pinMode(CS, OUTPUT);
 
  // Initialisation carte SD
  if (!SD.begin(CS))
  {
    Serial.println("    * Carte absente");
    Serial.println("    * Erreur de cablage");
    return;
  }
  Serial.println("Carte initialisee.");
  delay(2000);
  
}
 
void loop()
{
  
  String donnee = "";                                   // chaîne de caractères pour le stockage des valeurs à enregistrer
  for (int i = 0; i < 2; i++)                           // conversion des tensions et ajout à la chaîne de caractères
  {
    tension = analogRead(i);
    donnee+= String(tension);
    if (i < 1)
    {
      donnee += ",";                                   // placement d'une virgule entre les deux données
    }
  }
  
  File fichier = SD.open("datalog.txt", FILE_WRITE);   // ouverture du fichier datalog.txt

  
  if (fichier)                                         // si le fichier est disponible
  {
    fichier.println(donnee);                           // écriture des données dans le fichier
    fichier.close();
    Serial.println(donnee);                            // écriture des données dans le moniteur série
  } 
  else                                                 // si le fichier n'existe pas, afficher une erreur
  {
    Serial.println("Erreur d'ouverture fichier");
  }
  delay(1000);                                         // attente d'une seconde entre deux mesures et enregistrement
}
