/************************************************************************
*                                                                                                                                        
*    Test du module Pmod horloge                                            
*                                                                    
*************************************************************************
* Description:  Pmod_RTC                                               
* La date et l'heure sont affichées sur le moniteur série. 
* 
* 
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod RTC
*        
************************************************************************/

#include <Wire.h>                                  // appel de la bibliothèque 
#define MCP79410_Adresse 0x6F                      // adresse I2C du module Pmod RTC

void setup()
{
  Serial.begin(9600);                              // initialisation de la liaison série 
  Wire.begin();                                    // initialisation de la liaison I2C
  Init_RTC();                                      // initialisation du module RTC
}
 
void loop()
{
  DisplayRTCDay();                                  // affichage jour de la semaine
  DisplayRTCData(4,6);                              // affichage date
  Serial.print(".");
  DisplayRTCData(5,5);
  Serial.print(".");
  Serial.print("20");     
  DisplayRTCData(6,8);              
  Serial.print("  ");
  DisplayRTCData(2,6);                             // affichage de l'heure
  Serial.print(":");
  DisplayRTCData(1,7);
  Serial.print(":");
  DisplayRTCData(0,7);
  Serial.println();
    
delay(1000);
}

// Initialisation du module Pmod RTC
void Init_RTC(void)
{
  WriteRTCByte(0,0x00);                             // configuration registre des secondes
  WriteRTCByte(1,0x55);                             // configuration registre des minutes
  WriteRTCByte(2,0x13);                             // configuration registre des heures
  WriteRTCByte(3,0x03);                             // configuration registre des jours de la semaine
  WriteRTCByte(4,0x09);                             // configuration registre du jour
  WriteRTCByte(5,0x08);                             // configuration registre du mois
  WriteRTCByte(6,0x17);                             // configuration registre de l'année
  WriteRTCByte(0,0x80);                             // démarrage de l'horloge
  delay(100);
}

void WriteRTCByte(const unsigned char adresse, const unsigned char donnee)
{
  Wire.beginTransmission(MCP79410_Adresse);
  Wire.write(adresse);
  Wire.write(donnee);
  Wire.endTransmission();
} 

void DisplayRTCData(const unsigned char adresse, const unsigned char nb_bits)
{
  unsigned char data;
  data=ReadRTCByte(adresse);
  data=data & 0xFF>>(8-nb_bits);
  if (data<10) 
  {
    Serial.print("0");  
  }
  Serial.print(data,HEX);
}

void DisplayRTCDay()
{
  unsigned char data;
  data=ReadRTCByte(3);
  data=data & 0xFF>>(5);
  switch (data) 
  {
  case 1:
    Serial.print("Lundi ");
    break;
  case 2:
    Serial.print("Mardi ");
    break;
  case 3:
    Serial.print("Mercredi ");
    break;
  case 4:
    Serial.print("Jeudi ");
    break;
  case 5:
    Serial.print("Vendredi ");
    break;
  case 6:
    Serial.print("Samedi ");
    break;
  case 7:
    Serial.print("Dimanche ");
    break;
 }
}

unsigned char ReadRTCByte(const unsigned char adresse)
{
  unsigned char data;
 
  Wire.beginTransmission(MCP79410_Adresse);
  Wire.write(adresse);
  Wire.endTransmission();
  
  Wire.requestFrom(MCP79410_Adresse,1);
  while (Wire.available()) 
  {
    data=Wire.read();
  }
  return data;
}
