/************************************************************************
*                                                                                                                                        
*    Test du module Pmod RS485                                          
*                                                                    
*************************************************************************
* Description:  Pmod_RS485                                               
* Une led est commandée depuis une liaison série RS485.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod RS485 (le cavalier JP1 est présent)
*        
* Câblage           
*        Module<----------> Arduino
*        J1 broche 6        5 V
*        J1 broche 5        GND
*        J1 broche 4        7
*        J1 broche 3        9        
*        J1 broche 2        8
*        J1 broche 1        6
*        
************************************************************************/
#define RX 9                                      // affectation des broches 
#define TX 8
#define DE 7
#define RE 6

#include <SoftwareSerial.h>                       // appel de la bibliothèque
SoftwareSerial RS485(RX, TX);                     // création de l'objet RS485

int recu;

void setup()
{
 Serial.begin(9600);                              // initialisation du moniteur série
 RS485.begin(9600);                               // initialisation de la liaison série RS485
 pinMode(DE,OUTPUT);                              // configuration de la broche DE en sortie
 pinMode(RE,OUTPUT);                              // configuration de la broche RE en sortie
 digitalWrite(DE, HIGH);                          // validation de l'émission 
 digitalWrite(RE, HIGH);                          // blocage de la réception  
 Serial.println("Commande led par liaison série:");
 Serial.println("Extinction:0 Allumage:1");
 delay(500);
}

void loop()
{  
if (Serial.available())                           // si la liaison série RS232 (moniteur série) reçoit un caractère
  {
    recu = Serial.read();                         // lecture et stockage dans la variable recu
    RS485.write(recu);                            // envoi de la variable recu
  }                
}

