/************************************************************************
*                                                                                                                                        
*    Test du module Pmod RS232                                          
*                                                                    
*************************************************************************
* Description:  Pmod_RS232                                               
* Une carte Arduino + module Pmod RS232 demande à une autre carte Arduino  
* + module Pmod RS232 de lui envoyer une chaîne de caractères.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod RS232 (Le cavalier JP1 n'est pas positionné,
*        le cavalier JP2 est positionné).
*        
************************************************************************/
#define RX 9                                               // affectation des broches 
#define TX 8

#include <SoftwareSerial.h>                                // appel de la bibliothèque
SoftwareSerial RS232(RX, TX);                              // création de l'objet RS232

int recu[20];     
int i;

void setup()
{
 Serial.begin(9600);                                       // initialisation du moniteur série
 RS232.begin(9600);                                        // initialisation de la liaison série RS232
}

void loop()
{  
      i = 0 ;
      while ( RS232.available()>0 )                        // tant que des caractères sont présents sur la liaison RS232  
      {
            recu[i] = RS232.read();                        // lecture caractère par caractère
            Serial.print(recu[i]);                         // affichage dans le moniteur série
            Serial.print(",");
            i++;
      }
RS232.print('0');                                          // demande de l'envoi de la chaîne depuis l'émetteur
} 

