/************************************************************************
*                                                                                                                                        
*    Test du module Pmod transmetteur 2.4 GHz                                      
*                                                                    
*************************************************************************
* Description:  Pmod_RF2                                              
* Les données échangées entre deux modules RF2 sont affichés 
* dans le moniteur série (basé sur l'exemple de la bibliothèque).
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod RF2 (télécharger la bibliothèque 
*        https://github.com/karlp/Mrf24j40-arduino-library)
************************************************************************/

// Appel des bibliothèques
#include <SPI.h>
#include <mrf24j.h>

#define Reset 6                                            // affectation des broches 
#define CS 10
#define Interruption 2


Mrf24j mrf(Reset, CS, Interruption);                       // création de l'objet mrf

long last_time;
long tx_interval = 1000;
unsigned long current_time;

void setup(void) 
{
   Serial.begin(9600);                                  // initialisation de la liaison série 
   mrf.reset();
   mrf.init();
   mrf.set_pan(0x0000);                                 // adresse du canal
   mrf.address16_write(0x0001);                         // adresse du module N°1
   attachInterrupt(0, interrupt_routine, CHANGE);     
   last_time = millis();
   interrupts();                     
}

void interrupt_routine() 
{
    mrf.interrupt_handler();                           // création de l'objet mrf.interrupt
}

void loop() 
{
  mrf.check_flags(&handle_rx, &handle_tx);
  current_time = millis();
  if (current_time - last_time > tx_interval) 
    {
        last_time = current_time;
        Serial.println("Envoi de la chaine ");
        mrf.send16(0x0002, "Bonjour");                 // envoi de la chaine au module N°2
    }
}

void handle_rx() 
{
    Serial.print("Reception de la chaine ");
    Serial.print(mrf.get_rxinfo()->frame_length, DEC);
    Serial.println(" octets");
    
    if(mrf.get_bufferPHY())
    {
      Serial.println("Packet data (PHY Payload):");
      for (int i = 0; i < mrf.get_rxinfo()->frame_length; i++) 
      {
          Serial.print(mrf.get_rxbuf()[i]);
      }
    }
    
    Serial.println("\r\nASCII data :");
    for (int i = 0; i < mrf.rx_datalength(); i++) 
    {
        Serial.write(mrf.get_rxinfo()->rx_data[i]);
    }
    
    Serial.print("\r\nLQI/RSSI=");
    Serial.print(mrf.get_rxinfo()->lqi, DEC);
    Serial.print("/");
    Serial.println(mrf.get_rxinfo()->rssi, DEC);
}

void handle_tx() 
{
    if (mrf.get_txinfo()->tx_ok) 
    {
        Serial.println("Transmission OK");
    } 
    else 
    {
        Serial.print("Echec transmission ");
        Serial.print(mrf.get_txinfo()->retries);
        Serial.println(" essais\n");
    }
}

