/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur N/A R/2R                                           
*                                                                    
*************************************************************************
* Description:  Pmod_R2R                                                
* La tension de sortie est paramétrable en fonction des niveaux logiques
* appliqués sur les broches 2 à 9 de l'Arduino.
* La tension de sortie est la somme de toutes Les composantes.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod R2R
*        
************************************************************************/

void setup()
{
  for (int i=2; i<=9; i++)                 // configuration des broches 2 à 9 en sortie
  {
     pinMode(i,OUTPUT);
  } 
}

void loop()
{
 // L'entrée D7 du module à l'état haut impose une composante de VCC/2
 digitalWrite(9,HIGH);
 // L'entrée D6 du module à l'état haut impose une composante de VCC/4
 digitalWrite(8,LOW);
 // L'entrée D5 du module à l'état haut impose une composante de VCC/8
 digitalWrite(7,LOW);
 // L'entrée D4 du module à l'état haut impose une composante de VCC/16
 digitalWrite(6,LOW);
 // L'entrée D3 du module à l'état haut impose une composante de VCC/32
 digitalWrite(5,HIGH);
 // L'entrée D2 du module à l'état haut impose une composante de VCC/64
 digitalWrite(4,HIGH);
 // L'entrée D1 du module à l'état haut impose une composante de VCC/128
 digitalWrite(3,HIGH);
 // L'entrée D0 du module à l'état haut impose une composante de VCC/256
 digitalWrite(2,HIGH);
}


