/************************************************************************
*                                                                                                                                        
*    Test du module Pmod afficheur OLEDRGB                                         
*                                                                    
*************************************************************************
* Description:  Pmod_OLEDRGB                                               
* Le message "Test module Pmod Digilent Lextronic" est affiché sur
* l'afficheur avec des couleurs et des tailles différentes
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod OLEDRGB (télécharger les bibliothèques https://github.com/adafruit/Adafruit-SSD1331-OLED-Driver-Library-for-Arduino et 
*           https://github.com/adafruit/Adafruit-GFX-Library)
*       
*        
************************************************************************/

// Affectation des broches 
#define sck 13
#define mosi 11
#define cs 10
#define res 9
#define dc 8


// Définition des couleurs
#define	NOIR           0x0000
#define	BLEU           0x001F
#define	ROUGE          0xF800
#define	VERT           0x07E0
#define CYAN           0x07FF
#define MAGENTA        0xF81F
#define JAUNE          0xFFE0  
#define BLANC          0xFFFF

// Appel des bibliothèques
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1331.h>
#include <SPI.h>

Adafruit_SSD1331 afficheur = Adafruit_SSD1331(cs, dc, mosi, sck, res);     //création de l'objet

void setup(void) 
{
  afficheur.begin(); // initialisation de l'objet afficheur
}

void loop() 
{
  afficheur.fillScreen(NOIR);                                  // fond de l'écran noir
  afficheur.setTextColor(CYAN);                                // couleur du texte en cyan
  afficheur.setCursor(0,0);                                    // placement du curseur en x=0 et y=15
  afficheur.print("Test module Pmod");                         // écriture du texte
  delay(500);                                                  // pause de 500 ms
  afficheur.setCursor(0,15);                                   // placement du curseur en x=0 et y=15
  afficheur.setTextSize(2);                                    // taille du texte 
  afficheur.setTextColor(ROUGE);                               // couleur du texte en rouge
  afficheur.println("DIGILENT");                               // écriture du texte
  afficheur.setCursor(20,40);                                  // placement du curseur en x=20 et y=40
  afficheur.setTextSize(1);                                    // taille du texte
  afficheur.setTextColor(VERT);                                // couleur du texte en vert
  afficheur.println("LEXTRONIC");                              // écriture du texte
  afficheur.drawFastHLine(1, 60, afficheur.width()-1, BLEU);   // ligne bleue de x=1 à largeur de l'écran-1 et y=60
  delay(2000);                                                 // pause de 2 s
  afficheur.fillScreen(NOIR);                                  // fond de l'écran noir (effacement de l'écran)
  afficheur.fillRoundRect(5, 5, 30, 40, 5, BLEU);              // drapeau bleu blanc rouge
  afficheur.fillRoundRect(35, 5, 30, 40, 5, BLANC);
  afficheur.fillRoundRect(65, 5, 30, 40, 5, ROUGE);
  afficheur.fillCircle(90, 55, 5, JAUNE);                      // cercle jaune de rayon=5 en x=90 et y=55 
  delay(2000);                                                 // pause de 2 s
}



