/************************************************************************
*                                                                                                                                        
*    Test du module Pmod afficheur OLED                                        
*                                                                    
*************************************************************************
* Description:  Pmod_OLED                                              
* Un nuage de points est affiché aléatoirement puis lE MESSAGE lextronic apparaît
* et clignote 3 fois
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod OLED 
*        (télécharger les bibliothèques https://github.com/adafruit/Adafruit_SSD1306 et 
*         https://github.com/adafruit/Adafruit-GFX-Library)
*            
************************************************************************/

// Affectation des broches 
#define OLED_MOSI   9
#define OLED_CLK   10
#define OLED_DC    11
#define OLED_CS    12
#define OLED_RESET 13

// Appel des bibliothèques
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <SPI.h>

Adafruit_SSD1306 afficheur(OLED_MOSI, OLED_CLK, OLED_DC, OLED_RESET, OLED_CS);    //création de l'objet

int x;
int y;

void setup(void) 
{
   afficheur.begin();           // initialisation de l'objet afficheur
   afficheur.display();         // rafraichissement de l'écran
   afficheur.clearDisplay();    // effacement de l'écran
   afficheur.display();         // rafraichissement de l'écran
}

void loop() 
{
   afficheur.clearDisplay();                  // effacement de l'écran
   afficheur.display();                       // rafraichissement de l'écran          
   for (int i=0; i <= 50; i++)                // apparition du nuage de points
   {
      x=random(128);                          // x prend une valeur aléatoire comprise entre 0 et 128
      y=random(32);                           // y prend une valeur aléatoire comprise entre 0 et 32
      afficheur.drawPixel(x, y, WHITE);       // affichage d'un pixel en (x,y)
      afficheur.display();                    // rafraichissement de l'écran
      delay(50);                              // pause de 50 ms
   }  
   afficheur.setTextSize(2);                  // configuration de la taille des caractères
   afficheur.setTextColor(WHITE);         
   afficheur.setCursor(10,10);                // placement du curseur en x=10 et y=10
   afficheur.println("LEXTRONIC");            // écriture de LEXTRONIC
   afficheur.display();                       // rafraichissement de l'écran  
   delay(1000);
   for (int i=0; i <= 3; i++)                 // clignotement du message
   {
     afficheur.setCursor(10,10); 
     afficheur.println("LEXTRONIC");
     afficheur.display();
     delay(1000);
     afficheur.clearDisplay();
     afficheur.display();
     delay(500);
   } 
}



