/************************************************************************
*                                                                                                                                        
*    Test du module Pmod contrôleur réseau                                            
*                                                                    
*************************************************************************
* Description:  Pmod_NIC100                                               
* Un serveur HTTP est créé, permettant la communication entre un ordinateur 
* et la carte Arduino.
* Sur votre ordinateur lancer l'invite de commandes et taper la commande suivante : 
* ping 192.168.1.83.

*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod NIC100 
*        3. Module Adafruit TXB0108
*        4. Câble réseau croisé RJ45
*        
************************************************************************/

#include <SPI.h>                                     // appel des bibliothèques
#include <Ethernet.h>

byte MAC[] = { 0x00, 0x18, 0xE3, 0x01, 0xD4, 0x06 }; // adresse MAC du module Pmod NIC100
// voir étiquette livrée avec le module

IPAddress IP(192,168,1, 83);                         // adresse IP donné module Pmod NIC100

EthernetServer serveurHTTP(80);                      // création de l'objet serveur sur le port 80 (port HTTP)

void setup()
  {
  Ethernet.begin(MAC, IP);                           // connexion Ethernet avec l'adresse MAC et l'adresse IP
  serveurHTTP.begin();
  }

void loop()
  {
  }
  

