/************************************************************************
*                                                                                                                                        
*    Test du module Pmod micro amplifié                                          
*                                                                    
*************************************************************************
* Description:  Pmod_MIC3                                               
* Le son capté par le module est affiché dans le traceur série.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod MIC3
*        
* Le câblage est identique au module Pmod AD1        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

int i;
byte recu[3];    // stockage des données du module
int X;
long somme = 0;

void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  SPI.begin();                          // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);           // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16); // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{
  digitalWrite(CS, LOW);               // activation de la ligne CS
  delayMicroseconds(20);               
  for (i=0;i<2;i=i+1)                         
       {
       recu[i] = SPI.transfer(0);      // envoi de 2 données pour récupérer la valeur de la conversion sur deux octets
       delayMicroseconds(20);                 
       }
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS
  X = recu[1];                         // X a un format de 12 bit
  X |= (recu[0] << 8);
 
   for(int i=0; i<32; i++)             // élaboration de la courbe de son
    {
        somme = somme + X;
    }

    somme >>= 5;
    Serial.println(somme);             // affichage dans le traceur série
    delay(10);
}
