/************************************************************************
*                                                                                                                                        
*    Test du module Pmod clavier 16 touches                                           
*                                                                    
*************************************************************************
* Description:  Pmod_KYPD                                               
* L'activation d'une touche du clavier est affichée sur un afficheur LCD Série.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod KYPD (télécharger la bibliothèque http://playground.arduino.cc/Code/Keypad)
*        3. Module Pmod CLS (voir liste des instructions https://reference.digilentinc.com/pmod/pmod/cls/user_guide)
*        
************************************************************************/

//Déclaration d'un port série
#include <SoftwareSerial.h>  
SoftwareSerial lcd(12,13); // RX, TX 

#include <Keypad.h>
const byte LIGNE = 4;       // 4 lignes
const byte COLONNE = 4;     // 4 colonnes
char touche;

//Déclaration des touches du clavier
char hexaKeys[LIGNE][COLONNE] = 
{
  {'1','2','3','A'},
  {'4','5','6','B'},
  {'7','8','9','C'},
  {'0','F','E','D'}
};

//Affectation des broches du clavier
byte ligne_pin[LIGNE] = {2, 3, 4, 5}; 
byte colonne_pin[COLONNE] = {6, 7, 8, 9}; 

Keypad clavier = Keypad( makeKeymap(hexaKeys), ligne_pin, colonne_pin, LIGNE, COLONNE); // création de l'objet clavier

void setup() 
{
 lcd.begin(9600);                          // initialisation de la liaison série de l'afficheur
 lcd.write("\x1b[j");                      // effacement de l'afficheur
 lcd.write("\x1b[0h");                     // configuration de l'afficheur en mode écriture du message sur deux lignes
}

void loop() 
{
 lcd.write("\x1b[j");                      // effacement de l'afficheur
 lcd.write("\x1b[0;4H");                   // positionnement du curseur 1ère ligne 4ème colonne
 lcd.print("Appuyer");
 lcd.write("\x1b[1;1H");                   // positionnement du curseur 2nde ligne 1ère colonne
 lcd.print("sur une touche"); 
 delay(100);
 touche=clavier.getKey();                  // acquisition de la touche
 if (touche!=0x00)                         // si aucune touche est active, la fonction getKey renvoie le caractère NULL (0x00)
 {
 lcd.write("\x1b[j");                      // effacement de l'afficheur 
 lcd.print("Touche:");                     
 lcd.print(touche);                        // affichage de la touche
 delay(1000);
 }
}                      
    

