/************************************************************************
*                                                                                                                                        
*    Test du module Pmod joystick 2                                           
*                                                                    
*************************************************************************
* Description:  Pmod_JSTK2                                               
* Les valeurs X et Y sont affichées dans le moniteur série sous forme de 
* tableau et la led du module s'allume avec une couleur différente lorsque 
* les boutons sont actifs.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod JSTK2 
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

int i;
byte recu[7];    // stockage des données du module
int X;
int Y;
int cmd=0;
void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  SPI.begin();                          // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);           // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16); // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{
  digitalWrite(CS, LOW);               // activation de la ligne CS
  delayMicroseconds(15);               // voir doc: pause de 15us après l'activation de la ligne CS  
  for (i=0;i<6;i=i+1)                         
       {
       recu[i] = SPI.transfer(cmd);    // envoi de 6 données pour récupérer les données du module
       delayMicroseconds(10);          // voir doc: pause de 10us après chaque envoi       
       }
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS
  X = recu[0];                         // X a un format de 10 bit
  X |= (recu[1] << 8);
  Y = recu[2];                         // Y a un format de 10 bit
  Y |= (recu[3] << 8);
  
  for (i=0;i<6;i=i+1)                  // écriture dans le moniteur série   
       {
       Serial.print("i");
       Serial.print(i);
       Serial.print("=");
       Serial.print(recu[i]); 
       Serial.print('\t');             // tabulation
       }
  Serial.print("X=");
  Serial.print(X);
  Serial.print('\t');                  // tabulation
  Serial.print("Y=");
  Serial.println(Y);
  delay(10);
  switch (recu[4]) 
  {
  case 1:                              // bouton joystick actif
    // allumage de la led en rouge
    digitalWrite(CS, LOW);             // activation de la ligne CS
    SPI.transfer(0x84);                
    delayMicroseconds(15);
    SPI.transfer(255);                 
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    digitalWrite(CS, HIGH);           // désactivation de la ligne CS          
    delay(1000);
    // extinction de la led 
    digitalWrite(CS, LOW);            // activation de la ligne CS
    SPI.transfer(0x84);                   
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    digitalWrite(CS, HIGH);            // désactivation de la ligne CS
    break;
  case 2:                              // bouton trigger actif
    // allumage de la led en vert
    digitalWrite(CS, LOW);             // activation de la ligne CS
    SPI.transfer(0x84);                
    delayMicroseconds(15);
    SPI.transfer(0);                 
    delayMicroseconds(15);
    SPI.transfer(255);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    digitalWrite(CS, HIGH);           // désactivation de la ligne CS          
    delay(1000);
    // extinction de la led 
    digitalWrite(CS, LOW);            // activation de la ligne CS
    SPI.transfer(0x84);                   
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    digitalWrite(CS, HIGH);            // désactivation de la ligne CS
    break;
  case 3:                              // deux boutons actifs
    // allumage de la led en bleu
    digitalWrite(CS, LOW);             // activation de la ligne CS
    SPI.transfer(0x84);                
    delayMicroseconds(15);
    SPI.transfer(0);                 
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(255);                  
    delayMicroseconds(15);
    digitalWrite(CS, HIGH);           // désactivation de la ligne CS          
    delay(1000);
    // extinction de la led 
    digitalWrite(CS, LOW);            // activation de la ligne CS
    SPI.transfer(0x84);                   
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    SPI.transfer(0);                  
    delayMicroseconds(15);
    digitalWrite(CS, HIGH);            // désactivation de la ligne CS
    break;
  default:
  break;
  delay(1000);
  
  }
}
