/************************************************************************
*                                                                                                                                        
*    Test du module Pmod joystick                                           
*                                                                    
*************************************************************************
* Description:  Pmod_JSTK                                               
* Les valeurs X et Y sont affichées dans le moniteur série sous forme de 
* tableau et les led LD1 et LD2 du module s'allument lorsque les boutons  
* BTN1 et BTN2 sont actifs.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod JSTK 
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

int i;
byte recu[6];    // stockage des données du module
int X;
int Y;
int led=128;
void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  SPI.begin();                          // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);           // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16); // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{
  digitalWrite(CS, LOW);               // activation de la ligne CS
  delayMicroseconds(15);               // voir doc: pause de 15us après l'activation de la ligne CS  
  for (i=0;i<5;i=i+1)                         
       {
       recu[i] = SPI.transfer(led);    // envoi de 5 données pour récupérer les données du module, les led sont éteintes 
       delayMicroseconds(10);          // voir doc: pause de 10us après chaque envoi       
       }
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS
  X = recu[0];                         // X a un format de 10 bit
  X |= (recu[1] << 8);
  Y = recu[2];                         // Y a un format de 10 bit
  Y |= (recu[3] << 8);
  
  for (i=0;i<5;i=i+1)                  // écriture dans le moniteur série   
       {
       Serial.print("i");
       Serial.print(i);
       Serial.print("=");
       Serial.print(recu[i]); 
       Serial.print('\t');             // tabulation
       }
  Serial.print("X=");
  Serial.print(X);
  Serial.print('\t');                  // tabulation
  Serial.print("Y=");
  Serial.println(Y);
  delay(10);
  switch (recu[4]) 
  {
  case 2:                              // BTN1 actif
    led=129;
    break;
  case 4:                              // BTN2 actif
    led=130;
    break;
  case 6:                              // BTN1 et BTN2 actifs
    led=131;
    break;
  default:
    led=128;
  break;
  }
}
