/************************************************************************
*                                                                                                                                        
*    Test du module Pmod analyseur d'impédance (basé sur le programme de Michael Meli)                                             
*                                                                    
*************************************************************************
* Description:  Pmod_IA                                              
* Le résultat de la mesure est affiché sur le moniteur série.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod IA (télécharger la bibliothèque https://github.com/mjmeli/arduino-ad5933)
*        
************************************************************************/

#include <Wire.h>
#include "AD5933.h"

#define START_FREQ  (80000)
#define FREQ_INCR   (1000)
#define NUM_INCR    (40)
#define REF_RESIST  (10000)

double gain[NUM_INCR+1];
int phase[NUM_INCR+1];

void setup(void)
{
  Serial.begin(9600);                                           // initialisation de la liaison série
  Wire.begin();                                                 // initialisation de la liaison I2C 
  if (AD5933::calibrate(gain, phase, REF_RESIST, NUM_INCR+1))   // si calibration du module est réussie
    Serial.println("Calibration du module reussie");
    else
    Serial.println("Echec de la calibration du module");
}

void loop(void)
{
 int real, imag, i = 0, cfreq = START_FREQ/1000;
    if (!(AD5933::setPowerMode(POWER_STANDBY) &&          
          AD5933::setControlMode(CTRL_INIT_START_FREQ) && 
          AD5933::setControlMode(CTRL_START_FREQ_SWEEP))) 
         {
             Serial.println("Impossible d initialiser la variation de frequence");
         }
    while ((AD5933::readStatusRegister() & STATUS_SWEEP_DONE) != STATUS_SWEEP_DONE) {
       
        if (!AD5933::getComplexData(&real, &imag)) {
            Serial.println("Impossible d obtenir une mesure");
        }
        Serial.print("R=");
        Serial.print(real);
        Serial.print("/I=");
        Serial.print(imag);
        double magnitude = sqrt(pow(real, 2) + pow(imag, 2));  // calcul de l'amplitude
        double impedance = 1/(magnitude*gain[i]);              // calcul de l'impédance
        Serial.print("  |Z|=");
        Serial.println(impedance);
        i++;
        cfreq += FREQ_INCR/1000;
        AD5933::setControlMode(CTRL_INCREMENT_FREQ);
    }
    Serial.println("Balayage de frequence reussie");

    if (!AD5933::setPowerMode(POWER_STANDBY))
        Serial.println("Impossible de configurer en mode veille");
 delay(5000);
}



