/************************************************************************
*                                                                                                                                        
*    Test du module Pmod hygromètre/temp                                            
*                                                                    
*************************************************************************
* Description:  Pmod_HYGRO                                               
* La valeur de la température et de l'humidité sont affichées 
* sur le moniteur série.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod HYGRO (télécharger la bibliothèque 
*        https://github.com/closedcube/ClosedCube_HDC1080_Arduino)
*       
* Câblage           
*        Module<----------> Arduino
*        J1 broche 6        5 V
*        J1 broche 5        GND
*        J1 broche 4        A5
*        J1 broche 2        A4      
*        
************************************************************************/                

// appel des bibliothèques
#include <SPI.h>
#include "ClosedCube_HDC1080.h"

ClosedCube_HDC1080 hdc1080;                    // création de l'objet

void setup()
{
  Serial.begin(9600);                          // initialisation de la liaison série 
  hdc1080.begin(0x40);                         // initialisation du capteur
}
 
void loop()
{
 Serial.print("Temperature en C = ");       
 Serial.println(hdc1080.readTemperature());    // acquisition de la température
 Serial.print("Humidite en % = ");
 Serial.println(hdc1080.readHumidity());       // acquisition de l'humidité
 delay(1000);
}  
