/************************************************************************
*                                                                                                                                        
*    Test du module Pmod commande moteur cc HB5                                           
*                                                                    
*************************************************************************
* Description:  Pmod_HB5                                               
* Le bouton poussoir BTN0 commande l'arrêt du moteur.
* Le bouton poussoir BTN1 commande l'augmentation de la vitesse du moteur.
* Le bouton poussoir BTN2 commande la diminution de la vitesse du moteur.
* La vitesse du moteur est affichée sur le moniteur série.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod HB5
*        3. Module Pmod BTN
*        
************************************************************************/
// Affectation des broches
#define DIRECTION 2
#define VALIDATION 3
#define BTN_0 4
#define BTN_1 5
#define BTN_2 6


boolean etat_1;
boolean etat_2;
boolean etat_3;
int vitesse=0;
int aff_vitesse;

void setup()
{
  Serial.begin(9600);                      // initialisation du moniteur série
  pinMode(DIRECTION,OUTPUT);               // configuration des broches
  pinMode(VALIDATION,OUTPUT); 
  pinMode(BTN_0,INPUT);
  pinMode(BTN_1,INPUT);
  pinMode(BTN_2,INPUT);
}

void loop()
{
 etat_1=digitalRead(BTN_0);               // lecture de l'interrupteur BTN_0
 etat_2=digitalRead(BTN_1);               // lecture de l'interrupteur BTN_1
 etat_3=digitalRead(BTN_2);               // lecture de l'interrupteur BTN_2
 if (etat_1==HIGH)                        // arrêt du moteur
  {
    vitesse=0;
  }
 if (etat_2==HIGH)                        // augmentation de la vitesse                 
  {
   vitesse=vitesse+10;
   if(vitesse>255)                        // le rapport cyclique est à 100 %
    {
    vitesse=255;
    }
  }
 if (etat_3==HIGH)                        // diminution de la vitesse               
  {
   vitesse=vitesse-10;
   if(vitesse<0)                          // le rapport cyclique est à 0 %
    {
    vitesse=0;
    }
  }

digitalWrite(DIRECTION,HIGH);             // pour faire tourner le moteur dans l'autre sens, mettre LOW à la place de HIGH
analogWrite(VALIDATION,vitesse);
aff_vitesse=map(vitesse,0,255,0,100);     // changement d'échelle pour l'affichage (0 à 100 %)
Serial.print("La vitesse du moteur est egale a ");
Serial.print(aff_vitesse);
Serial.println(" %.");
delay(100);
}


