/************************************************************************
*                                                                                                                                        
*    Test du module Pmod commande moteur cc HB3                                           
*                                                                    
*************************************************************************
* Description:  Pmod_HB3                                               
* L'interrupteur SW1 commande l'arrêt ou la rotation du moteur.
* L'interrupteur SW2 commande le sens de rotation du moteur.
* L'état du moteur est affiché sur le moniteur série.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod HB3
*        3. Module Pmod SWT
*        
************************************************************************/
// Affectation des broches
#define DIRECTION 2
#define VALIDATION 3
#define SWT_1 4
#define SWT_2 5

boolean inter_1;
boolean inter_2;

void setup()
{
  Serial.begin(9600);                                              // initialisation du moniteur série
  pinMode(DIRECTION,OUTPUT);                         // configuration des broches
  pinMode VALIDATION,OUTPUT); 
  pinMode(SWT_1,INPUT);
  pinMode(SWT_2,INPUT);
}

void loop()
{
 inter_1=digitalRead(SWT_1);                         // lecture de l'interrupteur SW1
 inter_2=digitalRead(SWT_2);                         // lecture de l'interrupteur SW2
 if (inter_1==HIGH)                                            // arrêt du moteur
  {
    digitalWrite(DIRECTION,LOW);
    digitalWrite(VALIDATION,LOW);
    Serial.println("Le moteur est arrete");          // affichage dans le moniteur série
  }
 else                                                                    // le moteur tourne
  {
   if (inter_2==HIGH)
   {
    digitalWrite(DIRECTION,HIGH);
    digitalWrite(VALIDATION,HIGH);
    Serial.println("Le moteur tourne dans le sens horaire");
   }
   else
   {
    digitalWrite(DIRECTION,LOW);
    digitalWrite(VALIDATION,HIGH);
    Serial.println("Le moteur tourne dans le sens anti-horaire");
   }
  }
}



