/************************************************************************
*                                                                                                                                        
*    Test du module Pmod double pont en H                                           
*                                                                    
*************************************************************************
* Description:  Pmod_HB1                                               
* La commande du moteur est réalisée à l'aide du moniteur série.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod HB1 (positionner les cavaliers JP1 et JP2 sur 1)
*        
************************************************************************/
// Affectation des broches
#define DIRECTION 2
#define VALIDATION 3

char sens=0;         
char recu[3];
boolean dir;          
int vitesse=0;
int vitesse_moteur;

void setup()
{
  Serial.begin(9600);                      // initialisation du moniteur série
  pinMode(DIRECTION,OUTPUT);               // configuration des broches
  pinMode(VALIDATION,OUTPUT); 
}

void loop()
{
  Serial.println("Rentrer le sens (A: avance ou R:recule) puis Envoyer");
  while (Serial.available()==0);                                         // attente du paramètre sens
  sens=Serial.read();                                                    // réception du paramètre sens                                              
  Serial.println("Rentrer la vitesse (000..100) puis Envoyer");
  while (Serial.available()==0);                                         // attente du paramètre vitesse
      for (int i=0;i<3;i++)                                              // réception du paramètre vitesse
      {
      recu[i]=Serial.read();                                
      delay(10);
      }
  vitesse=(recu[0]-48)*100+(recu[1]-48)*10+recu[2]-48;                   // reconstitution de la variable vitesse 
  vitesse_moteur=map(vitesse,0,100,0,255);                               // changement d'échelle pour la variable vitesse du moteur (0 à 255)
  Serial.print("Le moteur tourne dans le sens ");                        
  if (sens==65)                                                          // code ASCII de A
    {
       dir=HIGH;                                                         
       Serial.print("horaire");
    }
  if (sens==82)                                                         // code ASCII de R
    {
       dir=LOW;
       Serial.print("anti-horaire");
    }
  Serial.print(" avec une vitesse de ");
  Serial.print(vitesse);       
  Serial.println(" %");
  Serial.println(" ");
  digitalWrite(DIRECTION,dir);             
  analogWrite(VALIDATION,vitesse_moteur);
  delay(100);
}


