/************************************************************************
*                                                                                                                                        
*    Test du module Pmod Encodeur                                          
*                                                                    
*************************************************************************
* Description:  Pmod_ENC                                               
* Le sens de rotation de l'axe de l'encodeur est affiché dans le moniteur
* série. Un appui sur le bouton poussoir mémorise l'état d'un compteur dans 
* une variable.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod ENC
*        
************************************************************************/
// Affectation des broches
#define A 2         // sortie A de l'encodeur
#define B 3         // sortie B de l'encodeur
#define BTN 4       // bouton de l'encodeur

volatile boolean rotation;
volatile boolean sens;
int compteur = 0; 
int validation = 0; 


// Programme d'interruption
void Interruption ()  
{     
  if (digitalRead(A)==HIGH)
    {
    sens = digitalRead(B);                   // sens horaire
    }
  else
    {
      sens = !digitalRead(B);             // sens anti-horaire
    }
  rotation = HIGH;
}
void setup()
{
  attachInterrupt (0,Interruption,FALLING);   // interruption front descendant sur la sortie A 
  Serial.begin(9600);                         // initialisation du moniteur série
  pinMode(A,INPUT);                           // configuration de la broche N°2 en entrée
  pinMode(B,INPUT);                           // configuration de la broche N°3 en entrée
  pinMode(BTN,INPUT);                         // configuration de la broche N°4 en entrée
}

void loop()
{
  if (rotation==HIGH)                         // si une rotation a été détectée
  {       
    if (sens==HIGH)                           // si sens horaire
      {
      compteur++;                             // compteur s'incrémente
      }
    else
      {
      compteur--;                             // compteur se décrémente
      }
   rotation = LOW;         
   Serial.print ("Compteur=");                // écriture de la variable compteur
   Serial.println (compteur);
  }
   if (digitalRead(BTN)==HIGH)                // si le bouton est actif
     {
      validation=compteur;
      delay(200);                             // anti-rebonds
      Serial.print ("Validation=");           // écriture de la variable validation
      Serial.println (validation);
     }  
}
