/************************************************************************
*                                                                                                                                        
*    Test du module Pmod potentiomètre digital                                           
*                                                                    
*************************************************************************
* Description:  Pmod_DPOT                                               
* La tension de sortie du module évolue de 0 à 5 V toutes les secondes.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod DPOT 
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

int i;
int val=0;
float tension;

void setup()
{
  Serial.begin(9600);                         // initialisation de la liaison série 
  SPI.begin();                                // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);                 // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16);       // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{ 
  for (i=0;i<256;i=i+1)                         
       {
       digitalWrite(CS, LOW);                 // activation de la ligne CS
       delayMicroseconds(15);                 
       SPI.transfer(i);                       // envoi de la variable i (i=0->Vout=0V i=255->Vout=Vcc)
       val=analogRead(A0);                    // conversion AN              
       tension = map(val, 0, 1023, 0, 5000);  // tension varie de 0 à 5000 pour une variation de val de 0 à 255
       tension=tension/1000;
       Serial.print("i="); 
       Serial.print(i);
       Serial.print('\t');                    // tabulation
       Serial.print("val="); 
       Serial.print(val);
       Serial.print('\t');                    // tabulation
       Serial.print("Tension=");
       Serial.print(tension);
       Serial.println("V");
       digitalWrite(CS, HIGH);               // désactivation de la ligne CS
       delay(1000);    
       }
}
