/************************************************************************
*                                                                                                                                        
*    Test du module Pmod capteur de pression différentiel                                          
*                                                                    
*************************************************************************
* Description:  Pmod_DPG1                                               
* La pression est affichée sur le moniteur série.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod DPG1
*        3. Module Adafruit TXB0108
*        
* Câblage           
*        Module<----------> TXB0108 <-----------> Arduino
*        J1 broche 6                               3.3 V
*        J1 broche 5                               GND
*        J1 broche 4                               13
*        J1 broche 3                               12  
*        J1 broche 1                               10
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

int i;
byte recu[3];    // stockage des données du module
int valeur;
float pression;

void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  SPI.begin();                          // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);           // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16); // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{
  digitalWrite(CS, LOW);               // activation de la ligne CS
  delayMicroseconds(20);               
  for (i=0;i<2;i=i+1)                         
       {
       recu[i] = SPI.transfer(0);      // envoi de 2 données pour récupérer la valeur de la conversion sur deux octets
       delayMicroseconds(20);                 
       }
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS
  valeur = (recu[0] << 8|recu[1]);
  for (i=0;i<2;i=i+1)                  // écriture dans le moniteur série   
       {
       Serial.print("i");
       Serial.print(i);
       Serial.print("=");
       Serial.print(recu[i]); 
       Serial.print('\t');             // tabulation
       }
       
  pression=(valeur/4096.0-0.08)/0.09;  // formule donnée par la documentation
  Serial.print("Pression=");
  Serial.print(pression);
  Serial.println(" kPa");
  delay(1000);
}
