/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur N/A 12 bit 8 sorties                                            
*                                                                    
*************************************************************************
* Description:  Pmod_DA4                                               
* La tension des sorties A à E vont de 2,5V à 0,5V par pas de 0,5V 
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod DA4 
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

void setup()
{
 SPI.begin();                                // initialisation du port SPI
 SPI.setDataMode(SPI_MODE0);                 // configuration de la liaison SPI en mode 0
 SPI.setClockDivider(SPI_CLOCK_DIV16);       // configuration de l'horloge à 1MHz
 pinMode(CS, OUTPUT);
 digitalWrite(CS, LOW);                      // activation de la ligne CS  
 SPI.transfer(0b00001000);                   // configuration du convertisseur N/A (configuration du registre REF)
 delay(1); 
 SPI.transfer(0);
 delay(1);
 SPI.transfer(0);
 delay(1);
 SPI.transfer(0b00000001);                   // configuration du convertisseur N/A (tension de référence interne active VREF=1,25V)
 delay(1); 
 digitalWrite(CS, HIGH);                     // désactivation de la ligne CS 
 digitalWrite(CS, LOW);                      // activation de la ligne CS  
 SPI.transfer(0b00000011);                   // configuration du convertisseur N/A (écriture dans les voies du convertisseur)
 delay(1); 
 SPI.transfer(0b11110000);                   // configuration du convertisseur N/A (les 8 voies du convertisseur sont actives)
 delay(1);
 SPI.transfer(0);
 delay(1);
 SPI.transfer(0);                   
 delay(1); 
 digitalWrite(CS, HIGH);                     // désactivation de la ligne CS 
}

void loop()
{
 // la sortie A du convertisseur est à 2,5V
 digitalWrite(CS, LOW);                      // activation de la ligne CS  
 SPI.transfer(0b00000011);                   
 delay(1); 
 SPI.transfer(0b00001111);                   
 delay(1);
 SPI.transfer(0b11111111);
 delay(1);
 SPI.transfer(0);                   
 delay(1); 
 digitalWrite(CS, HIGH);                     // désactivation de la ligne CS 

 // la sortie B du convertisseur est à 2V
 digitalWrite(CS, LOW);                      // activation de la ligne CS  
 SPI.transfer(0b00000011);                   
 delay(1); 
 SPI.transfer(0b00011100);                   
 delay(1);
 SPI.transfer(0b11001101);
 delay(1);
 SPI.transfer(0);                   
 delay(1); 
 digitalWrite(CS, HIGH);                     // désactivation de la ligne CS 

 // la sortie C du convertisseur est à 1,5V
 digitalWrite(CS, LOW);                      // activation de la ligne CS  
 SPI.transfer(0b00000011);                   
 delay(1); 
 SPI.transfer(0b00101001);                   
 delay(1);
 SPI.transfer(0b10011010);
 delay(1);
 SPI.transfer(0);                   
 delay(1); 
 digitalWrite(CS, HIGH);                     // désactivation de la ligne CS 

 // la sortie D du convertisseur est à 1V
 digitalWrite(CS, LOW);                      // activation de la ligne CS  
 SPI.transfer(0b00000011);                   
 delay(1); 
 SPI.transfer(0b00110110);                   
 delay(1);
 SPI.transfer(0b01100110);
 delay(1);
 SPI.transfer(0);                   
 delay(1); 
 digitalWrite(CS, HIGH);                     // désactivation de la ligne CS

 // la sortie E du convertisseur est à 0,5V
 digitalWrite(CS, LOW);                      // activation de la ligne CS  
 SPI.transfer(0b00000011);                   
 delay(1); 
 SPI.transfer(0b01000011);                   
 delay(1);
 SPI.transfer(0b00110011);
 delay(1);
 SPI.transfer(0);                   
 delay(1); 
 digitalWrite(CS, HIGH);                     // désactivation de la ligne CS
}
