/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur N/A 16 bit 1 voie                                        
*                                                                    
*************************************************************************
* Description:  Pmod_DA3                                               
* La tension de sortie du module évolue de 0 à 2,5 V pour générer un signal 
* en dent de scie.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod DA3 (laisser le cavalier JP1 en place) 
*        
************************************************************************/

#define CS 10    // affectation de la broche CS
#define LDAC 9   // affectation de la broche LDAC
#include <SPI.h> // appel de la bibliothèque

int i;
int j;

void setup()
{
  Serial.begin(9600);                         // initialisation de la liaison série 
  SPI.begin();                                // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);                 // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16);       // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
  pinMode(LDAC, OUTPUT);
}
 
void loop()
{ 
  for (i=0;i<256;i=i+1)                         
     {
       for (j=0;j<256;j=j+1)
       {
       digitalWrite(LDAC, HIGH);             // désactivation de la ligne LDAC 
       digitalWrite(CS, LOW);                // activation de la ligne CS  
       SPI.transfer(i);                      // envoi des bit de poids fort
       SPI.transfer(j);                      // envoi des bit de poids faible
       digitalWrite(CS, HIGH);               // désactivation de la ligne CS
       digitalWrite(LDAC, LOW);              // activation de la ligne LDAC 
       /* la période du signal est de 2,4 s environ.
        * Si on souhaite l'augmenter, on introduit à chaque passage dans la boucle un retard
        * delay(1);  ou delayMicroseconds(50);
        */
       }     
    }
}
