/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur N/A 12 bit 2 sorties                                            
*                                                                    
*************************************************************************
* Description:  Pmod_DA2                                               
* La tension de sortie du module est choisie par l'utilisateur depuis le 
* moniteur série
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod DA2 
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

char tableau[4] = {0,0,0,0};
int i = 0;
long valeur;
long consigne;
int consigne_basse;
int consigne_haute;


void setup() 
{
  Serial.begin(115200);                       // initialisation de la liaison série 
  SPI.begin();                                // initialisation du port SPI
  SPI.setDataMode(SPI_MODE3);                 // configuration de la liaison SPI en mode 3
  SPI.setClockDivider(SPI_CLOCK_DIV16);       // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}

void loop() 
{ 
  Serial.println("Entrer la tension en mV sur 4 chiffres puis Envoyer");
  while (Serial.available()==0);                                  // attente de données
  for(i = 0;i<4;i++)                                              // boucle pour écrire les données dans un tableau
    {
    tableau[i]=Serial.read();                           
    delay(1);
    } 
  delay(100);  
  valeur=1000*(tableau[0]-48)+100*(tableau[1]-48)+10*(tableau[2]-48)+(tableau[3]-48);  // recomposition du nombre tension 
  consigne=4095*valeur;
  consigne=consigne/5000;
  consigne_haute=consigne>>8;                                      // consigne_haute récupère les 4 bit de poids fort de consigne
  consigne_basse=consigne&0XFF;                                    // consigne_basse récupère les 8 bit de poids faible de consigne
  digitalWrite(CS, LOW);                                           // activation de la ligne CS  
  SPI.transfer(consigne_haute);                                    // envoi de la consigne
  SPI.transfer(consigne_basse);
  delay(5);
  digitalWrite(CS, HIGH);                                          // désactivation de la ligne CS 
  delay(100);
  Serial.print("La tension de consigne est : ");
  Serial.print(valeur);
  Serial.println(" mV");
}
