/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur N/A 8 bit 4 sorties                                         
*                                                                    
*************************************************************************
* Description:  Pmod_DA1                                               
* Les sorties A1 et B1 délivrent des signaux carrés en opposition de phase
* avec une période programmable.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod DA1  
*        
************************************************************************/

#define CS 10                                 // affectation de la broche CS
#include <SPI.h>                              // appel de la bibliothèque

int periode=10;

void setup()
{
  SPI.begin();                                // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);                 // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16);       // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{ 
    digitalWrite(CS, LOW);                    // activation de la ligne CS  
    SPI.transfer(16);                         // envoi des bit de commande (sortie A active et sortie B inactive)
    SPI.transfer(255);                        // envoi des bit de données 
    digitalWrite(CS, HIGH);                   // désactivation de la ligne CS 
    delay(periode/2);                         // pause
    digitalWrite(CS, LOW);                    // activation de la ligne CS  
    SPI.transfer(12);                         // envoi des bit de commande (sortie A inactive et sortie B active)
    SPI.transfer(255);                        // envoi des bit de données                  
    digitalWrite(CS, HIGH);                   // désactivation de la ligne CS                  
    delay(periode/2);                         // pause
}
