/************************************************************************
*                                                                                                                                        
*    Test du module Pmod afficheur LCD interface série                                           
*                                                                    
*************************************************************************
* Description:  Pmod_CLS                                               
* Le message envoyé depuis le moniteur série est affiché sur l'afficheur.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod CLS (voir liste des instructions https://reference.digilentinc.com/pmod/pmod/cls/user_guide)
*        
************************************************************************/

//Déclaration d'un port série
#include <SoftwareSerial.h>  
SoftwareSerial lcd(2,3); // RX, TX 

char machaine[40]; 
int i=0;

void setup() 
{
 Serial.begin(9600);                       // initialisation de la liaison série du moniteur
 lcd.begin(9600);                          // initialisation de la liaison série de l'afficheur
 lcd.write("\x1b[j");                      // effacement de l'afficheur
 lcd.write("\x1b[0h");                     // configuration de l'afficheur en mode écriture du message sur deux lignes
 lcd.write("\x1b[0;5H");                   // positionnement du curseur 1ère ligne 5ème colonne
 lcd.print("Entrer");
 lcd.write("\x1b[1;1H");                   // positionnement du curseur 2nde ligne 1ère colonne
 lcd.print("votre message");
 delay(2000);
 lcd.write("\x1b[j");                      // effacement de l'afficheur
 lcd.write("\x1b[0;1H");                   // positionnement du curseur 1ère ligne 1ère colonne
 lcd.print("sur le moniteur");
 lcd.write("\x1b[1;5H");                   // positionnement du curseur 2nde ligne 5ème colonne
 lcd.print("serie");
}

void loop() 
{
   while (Serial.available())                // tant que des caractères sont présents sur la liaison série 
          {     
          machaine[i]=Serial.read();         // stockage des caractères dans le tableau machaine
          Serial.print(machaine[i]);         // écriture des caractères dans le moniteur série
          delay(10); 
          if (i==0)                          // si premier caractère
              {
              lcd.write("\x1b[j");           // effacement de l'afficheur 
              lcd.print(machaine[i]);        // envoi du caractère sur l'afficheur
              }
          else
              {
              lcd.print(machaine[i]);
              }
          i++;
         }
i=0;
}                      
    

