/************************************************************************
*                                                                                                                                        
*    Test du module Pmod BT2                                          
*                                                                    
*************************************************************************
* Description:  Pmod_BT2                                               
* L'envoi en Bluetooth depuis une tablette d'un '0' ou d'un '1' éteint ou 
* allume la led reliée à la broche 13 de l'Arduino.
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod BT2 
*        
************************************************************************/
#define led 13                               // affectation des broches
#define RX 2
#define TX 3


word octet_recu;                             // mot qui reçoit les trames émises 

// création d'une liaison série 
#include <SoftwareSerial.h>                  
SoftwareSerial bluetooth(RX,TX);             
 

void setup() 
{
Serial.begin(115200);                        // initialisation du moniteur série
bluetooth.begin(115200);                     // initialisation connexion série Bluetooth 
pinMode(led,OUTPUT) ;                        // configuration de la broche en sortie
}


void loop() {
recevoir();                                  // appel de la procédure recevoir
if (octet_recu==49)                          // si octet reçu est 1 (49=code ASCII de 1)
    {
    Serial.println("Led allumee");           // écriture dans le moniteur série
    digitalWrite(led,HIGH);                  // allumage de la led
    }    
if (octet_recu==48)                          // si octet reçu est 0 (48=code ASCII de 0)
    {
     Serial.println("Led eteinte");          // écriture dans le moniteur série
     digitalWrite(led,LOW);                  // extinction de la led
    }
delay(200);
    }

//procédure qui lit les trames de la tablette
void recevoir()
{
    if (bluetooth.available())               // si un caractère est présent sur la liaison bluetooth
    {
    octet_recu=bluetooth.read();             // lecture et stockage dans la variable octet_recu
    }
}
