/************************************************************************
*                                                                                                                                        
*    Test du module Pmod capteur de lumière                                           
*                                                                    
*************************************************************************
* Description:  Pmod_ALS                                               
* La valeur de la quantité de lumière est affichée sur le moniteur série.
* (Le capteur est saturé à une valeur de 125 environ)
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod ALS
*       
*        
************************************************************************/

#define CS 10                  // affectation de la broche CS

#include <SPI.h>               // appel de la bibliothèque
int i;
int recu[2];                  // stockage des données du module
int lumiere;

void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  SPI.begin();                          // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);           // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16); // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{
 digitalWrite(CS, LOW);               // activation de la ligne CS
 for (i=0;i<2;i=i+1)                         
       {
       recu[i] = SPI.transfer(0);      // acquisition des 2 octets de données
       }
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS 
  for (i=0;i<2;i=i+1)                  // écriture dans le moniteur série   
       {
       Serial.print("i");
       Serial.print(i);
       Serial.print("=");
       Serial.println(recu[i]); 
       }
   lumiere=(recu[0]<<3)|(recu[1]>>4); //reconstitution de la variable lumiere sur 8 bits
   Serial.print("Lumiere=");
   Serial.println(lumiere);
   delay(1000);
}  
