/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur A/N 24 bits 8 voies                                            
*                                                                    
*************************************************************************
* Description:  Pmod_AD5                                               
* Le résultat de la conversion A/N de la voie AIN1 est affiché sur le moniteur série.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod AD5 (laisser le cavalier en place et 
*        télécharger la bibliothèque https://github.com/annem/AD7193)
*        
************************************************************************/

#include <SPI.h>                                  // appel des bibliothèques 
#include <AD7193.h>                                  

AD7193 AD7193;                                    // création de l'objet AD7193

unsigned long valeur;
float tension;

void setup()
{
   Serial.begin(9600);                             // initialisation de la liaison série 
   Init_AD7193();
}
 
  
void loop()
{
  valeur = AD7193.ReadADCChannel(0);              // conversion A/N de la voie 1
  valeur = valeur >> 8;                           // extraction de la valeur
  tension = AD7193.DataToVoltage(valeur);         // récupération de la tension
  Serial.println("");
  Serial.print("Valeur=");
  Serial.print(valeur);
  Serial.print('\t');                             // tabulation
  Serial.print("Tension=");
  Serial.print(tension);
  Serial.println("V");
}

// Initialisation du module Pmod AD5
void Init_AD7193(void)
{
   AD7193.begin();                                 // initialisation du module Pmod AD5
   AD7193.AppendStatusValuetoData();               // configuration du module Pmod AD5
   AD7193.SetPGAGain(1);                          
   AD7193.SetAveraging(100);                       
   AD7193.Calibrate();
   AD7193.ReadRegisterMap();
}
