/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur A/N 12 bits 4 voies                                            
*                                                                    
*************************************************************************
* Description:  Pmod_AD2                                               
* Le résultat de la conversion A/N de la voie A0 est affiché sur le 
* moniteur série et sur un afficheur LCD série .
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod AD2 (position du cavalier sur V4)
*        3. Module Pmod CLS
*        
************************************************************************/

#include <Wire.h>                                  // appel de la bibliothèque 
#define AD7991_Adresse 0x28                        // adresse I2C du module Pmod AD2

//Déclaration d'un port série
#include <SoftwareSerial.h>  
SoftwareSerial lcd(2,3); // RX, TX 

int MSB;
int LSB;
int valeur;

void setup()
{
  Serial.begin(9600);                              // initialisation de la liaison série 
  Wire.begin();                                    // initialisation de la liaison I2C
  Init_AD7991();                                   // initialisation du module Pmod AD2
  lcd.begin(9600);                                 // initialisation de la liaison série de l'afficheur
  lcd.write("\x1b[j");                             // effacement de l'afficheur
  lcd.write("\x1b[0h");                            // configuration de l'afficheur en mode écriture du message sur deux lignes
}
 
void loop()
{
  Wire.beginTransmission(AD7991_Adresse);         // lancement de la mesure
  Wire.endTransmission();
  delay(10);
  Wire.requestFrom(AD7991_Adresse, 2);            // récupération des deux octets MSB et LSB
  if(Wire.available() <=2)
  {    
    MSB = Wire.read();
    LSB = Wire.read();
  }
  valeur=MSB<< 8 |LSB ;
  Serial.print("MSB=");                           // affichage dans le moniteur série
  Serial.println(MSB);
  Serial.print("LSB=");
  Serial.println(LSB);
  Serial.print("Valeur=");
  Serial.println(valeur);
  lcd.write("\x1b[j");                           // effacement de l'afficheur 
  lcd.print("MSB=");                             // écriture sur l'afficheur
  lcd.print(MSB);
  lcd.print(" LSB=");                            // écriture sur l'afficheur
  lcd.print(LSB);
  lcd.write("\x1b[1;0H");                        // positionnement du curseur 2nde ligne 1ère colonne
  lcd.print("Valeur=");                            // écriture sur l'afficheur
  lcd.print(valeur);
  delay(1000);
}

// Initialisation du module Pmod AD2
void Init_AD7991(void)
{
  Wire.beginTransmission(AD7991_Adresse);
  Wire.write(0x08);                              // configuraion de la liaison I2C en mode HIGH SPEED
  Wire.write(0x10);                              // configuration du module Pmod AD2 (lecture de V0)
  Wire.endTransmission();
}
