/************************************************************************
*                                                                                                                                        
*    Test du module Pmod convertisseur A/N 12 bits 2 voies                                          
*                                                                    
*************************************************************************
* Description:  Pmod_AD1                                               
* Le résultat de la conversion A/N de la voie A0 est affichée sur le 
* moniteur série.
* 
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod AD1
*        
************************************************************************/

#define CS 10    // affectation de la broche CS

#include <SPI.h> // appel de la bibliothèque

int i;
byte recu[3];    // stockage des données du module
int X;

void setup()
{
  Serial.begin(9600);                   // initialisation de la liaison série 
  SPI.begin();                          // initialisation du port SPI
  SPI.setDataMode(SPI_MODE0);           // configuration de la liaison SPI en mode 0
  SPI.setClockDivider(SPI_CLOCK_DIV16); // configuration de l'horloge à 1MHz
  pinMode(CS, OUTPUT);
}
 
void loop()
{
  digitalWrite(CS, LOW);               // activation de la ligne CS
  delayMicroseconds(20);               
  for (i=0;i<2;i=i+1)                         
       {
       recu[i] = SPI.transfer(0);      // envoi de 2 données pour récupérer la valeur de la conversion sur deux octets
       delayMicroseconds(20);                 
       }
  digitalWrite(CS, HIGH);              // désactivation de la ligne CS
  X = recu[1];                         // X a un format de 12 bit
  X |= (recu[0] << 8);
  for (i=0;i<2;i=i+1)                  // écriture dans le moniteur série   
       {
       Serial.print("i");
       Serial.print(i);
       Serial.print("=");
       Serial.print(recu[i]); 
       Serial.print('\t');             // tabulation
       }
  Serial.print("X=");
  Serial.println(X);
  delay(100);
}
