/************************************************************************
*                                                                                                                                        
*    Test du module Pmod accéléromètre ADXL362                                      
*                                                                    
*************************************************************************
* Description:  Pmod_ACL2                                              
* Les 3 composantes X, Y  et Z de l'accéléromètre sont affichés 
* dans le moniteur série
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod ACL2 (télécharger la bibliothèque https://github.com/annem/ADXL362)
*        3. Module Adafruit TXB0108
************************************************************************/

// Appel des bibliothèques
#include <SPI.h>
#include <ADXL362.h>

ADXL362 accelerometre;                                  // création de l'objet

int composante_X;
int composante_Y;
int composante_Z;
int temperature;

void setup(void) 
{
   Serial.begin(9600);                                  // initialisation de la liaison série 
   accelerometre.begin(10);                             // initialisation de l'accéléromètre
   accelerometre.beginMeasure();                         
}

void loop() 
{
  // acquisition des données de l'accéléromètre
  accelerometre.readXYZTData(composante_X, composante_Y, composante_Z, temperature);  
  Serial.print("composante_X=");
  Serial.print(composante_X); 
  Serial.print(" composante_Y=");
  Serial.print(composante_Y); 
  Serial.print(" composante_Z=");
  Serial.println(composante_Z);     
  delay(500);
}



