/************************************************************************
*                                                                                                                                        
*    Test du module Pmod accéléromètre ADXL345                                      
*                                                                    
*************************************************************************
* Description:  Pmod_ACL                                              
* Les 3 composantes X, Y  et Z de l'accéléromètre sont affichés 
* dans le moniteur série
*  
* Matériel
*        1. Arduino Uno                                       
*        2. Module Pmod ACL 
*            
************************************************************************/

// Déclaration des adresses du module  
#define ADXL345_Adresse  0x53                           // adresse de l'ADXL345
#define POWER_CTL  0x2D                                 // registre Power Control
#define DATA_FORMAT  0x31                               // registre Data Format
#define DATAX0  0x32                                    // bit de poids faible axe X
#define DATAX1  0x33                                    // bit de poids fort axe X
#define DATAY0  0x34                                    // bit de poids faible axe Y
#define DATAY1  0x35                                    // bit de poids fort axe Y
#define DATAZ0  0x36                                    // bit de poids faible axe Z
#define DATAZ1  0x37                                    // bit de poids fort axe Z

// Configuration du module
#define ADXL345_Precision2G   0x00
#define ADXL345_Precision4G   0x01
#define ADXL345_Precision8G   0x02
#define ADXL345_Precision16G  0x03
#define ADXL345_ModeMesure    0x08


// Appel de la bibliothèque
#include <Wire.h>

byte buffer[6];                                         // stockage des données du module
int i = 0;
int composante_X;
int composante_Y;
int composante_Z;

void setup(void) 
{
   Serial.begin(9600);                                  // initialisation de la liaison série 
   Wire.begin ();                                       // initialisation de la liaison I2C
   Wire.beginTransmission (ADXL345_Adresse);            // configuration du module
   Wire.write (DATA_FORMAT);
   Wire.write (ADXL345_Precision4G);
   Wire.endTransmission ();
   Wire.beginTransmission (ADXL345_Adresse);
   Wire.write (POWER_CTL);
   Wire.write (ADXL345_ModeMesure);
   Wire.endTransmission ();
}

void loop() 
{
   Wire.beginTransmission (ADXL345_Adresse);           
   Wire.write(DATAX0);
   Wire.endTransmission ();
   Wire.beginTransmission (ADXL345_Adresse);           
   Wire.requestFrom(ADXL345_Adresse, 6);                // récupération des 6 composantes
   i=0; 
   while(Wire.available())       
   { 
    buffer[i] = Wire.read();    
    i++;
   }
   Wire.endTransmission();        
   composante_X=(buffer[1] << 8) | buffer[0];           // élaboration des 3 composantes 
   composante_Y=(buffer[3] << 8) | buffer[2];
   composante_Z=(buffer[5] << 8) | buffer[4];
   Serial.print("X=");                                  // affichage des composantes dans le moniteur série
   Serial.print (composante_X);
   Serial.print('\t');                                  // tabulation
   Serial.print("Y=");
   Serial.print (composante_Y);
   Serial.print('\t');
   Serial.print("Z=");
   Serial.print (composante_Z);
   Serial.println("");
   delay(500);
}



