"""
This is the module containing keypad control functions
"""

# import necessary modules
from DesignSpark.Pmod.HAT import createPmod

# the KYPD object is needed in this module,
# but is initialized in the main program
KYPD = None


class KeyPressed(Exception):
    """This exception is raised when a key is pressed"""
    pass


def get_param():
    """ this function returns a two digit number
    entered on the Pmod KYPD """
    # set a new keymap: letters are mapped to 0
    keyMap = [['1', '2', '3', '0'], ['4', '5', '6', '0'],
              ['7', '8', '9', '0'], ['0', '0', '0', '0']]
    KYPD.setKeyMap(keyMap)

    # wait for a keypress
    key = wait_for_key()
    # save the first digit
    parameter = int(key) * 10
    # wait for a keypress
    key = wait_for_key()
    # save the second digit
    parameter = parameter + int(key)

    # restore default keymap
    KYPD.setKeyMapDefault()
    return parameter


def wait_for_key():
    """ this function wait until a key is pressed,
    then returns that key"""
    # read keypresses
    key = KYPD.getKey()
    # read keypresses until a key is pressed
    while key == None:
        key = KYPD.getKey()
    # debounce the keypad
    debounce()
    return key


def get_key():
    """ this function returns the debounced keypresses
    non-blocking: returns None if nothing was pressed """
    # get keypress
    key = KYPD.getKey()
    # debounce it
    debounce()
    return key


def debounce():
    """ this function debounces the keypad
    if 1000 consecutive states of the keypad
    are "None", the keyes are released """
    # enter in a loop
    flag = True
    while flag:
        # set the flag to False
        flag = False
        # inspect 1000 consecutive states of the keypad
        for _ in range(1000):
            # if a key is pressed
            if KYPD.getKey() != None:
                # restart the debouncing process
                flag = True
                break
    return
