"""
This is the module containing display control functions
"""

# import necessary modules
from DesignSpark.Pmod.HAT import createPmod
from luma.core.render import canvas

# the OLED object is needed in this module,
# but is initialized in the main program
OLED = None


def require(text):
    """ display a text to require a parameter """
    with canvas(OLED.getDevice()) as draw:
        # clear the screen
        draw.rectangle(OLED.getDevice().bounding_box,
                       outline="black", fill="black")
        # display some text
        draw.text((20, 10), "Enter the", fill="white")
        draw.text((0, 30), text, fill="red")
    return


def parameter(text, number, unit):
    """ display a parameter with unit """
    with canvas(OLED.getDevice()) as draw:
        # clear the screen
        draw.rectangle(OLED.getDevice().bounding_box,
                       outline="black", fill="black")
        # display some text
        draw.text((0, 10), text, fill="white")
        draw.text((30, 30), str(number), fill="green")
        draw.text((45, 30), unit, fill="white")

        draw.text((25, 45), "Exit", fill="yellow")
        draw.text((5, 52), "press any key", fill="yellow")
    return


def data_M1(average_temp, speed, min_temp, mode):
    """ display data in mode 1: temperature and speed """
    with canvas(OLED.getDevice()) as draw:
        # clear the screen
        draw.rectangle(OLED.getDevice().bounding_box,
                       outline="black", fill="black")

        # dislpay the temperature
        draw.text((5, 0), "Temperature: ", fill="white")
        draw.text((15, 10), "%.2f" % (average_temp + min_temp), fill="green")
        draw.text((50, 10), "\xb0" + "C", fill="white")

        # display the speed
        draw.text((5, 20), "Fan speed: ", fill="white")
        draw.text((15, 30), "%.2f" % speed, fill="green")
        draw.text((50, 30), "%", fill="white")

        # display current mode
        draw.text((80, 38), "M" + str(mode), fill="red")

        # display some text
        draw.text((25, 45), "Menu", fill="yellow")
        draw.text((5, 52), "press any key", fill="yellow")
    return


def data_M2(speed, time, mode):
    """ display data in mode 2: speed and remaining time left """
    with canvas(OLED.getDevice()) as draw:
        # clear the screen
        draw.rectangle(OLED.getDevice().bounding_box,
                       outline="black", fill="black")

        # display the speed
        draw.text((5, 0), "Speed: ", fill="white")
        draw.text((15, 10), str(speed), fill="green")
        draw.text((50, 10), "%", fill="white")

        # display the time left
        draw.text((5, 20), "Time left: ", fill="white")
        _, remainder = divmod(time.seconds, 3600)
        minutes, seconds = divmod(remainder, 60)
        draw.text((15, 30), str(minutes) + ":" + str(seconds), fill="green")
        draw.text((50, 30), "min:s", fill="white")

        # display the mode
        draw.text((80, 38), "M" + str(mode), fill="red")

        # display some text
        draw.text((25, 45), "Menu", fill="yellow")
        draw.text((5, 52), "press any key", fill="yellow")
    return


def menu():
    """ display the main menu """
    with canvas(OLED.getDevice()) as draw:
        # clear the screen
        draw.rectangle(OLED.getDevice().bounding_box,
                       outline="black", fill="black")

        # display option for key "A"
        draw.text((5, 0), "Press ", fill="white")
        draw.text((40, 0), "A", fill="green")
        draw.text((20, 10), "for mode ", fill="white")
        draw.text((75, 10), "1", fill="red")

        # display option for key "B"
        draw.text((5, 25), "Press", fill="white")
        draw.text((40, 25), "B", fill="green")
        draw.text((20, 35), "for mode", fill="white")
        draw.text((75, 35), "2", fill="red")

        # display some text
        draw.text((25, 45), "Exit", fill="yellow")
        draw.text((5, 52), "press any key", fill="yellow")
    return


def menu_M1():
    "display submenu for mode 1"
    with canvas(OLED.getDevice()) as draw:
        # clear the screen
        draw.rectangle(OLED.getDevice().bounding_box,
                       outline="black", fill="black")

        # display option for key "C"
        draw.text((5, 0), "Press ", fill="white")
        draw.text((40, 0), "C", fill="green")
        draw.text((50, 0), "to set", fill="white")
        draw.text((0, 10), "low temp. limt", fill="red")

        # display option for key "D"
        draw.text((5, 25), "Press", fill="white")
        draw.text((40, 25), "D", fill="green")
        draw.text((50, 25), "to set", fill="white")
        draw.text((0, 35), "high temp. limt", fill="red")

        # display some text
        draw.text((25, 45), "Exit", fill="yellow")
        draw.text((5, 52), "press any key", fill="yellow")
    return


def menu_M2():
    "display submenu for mode 2"
    with canvas(OLED.getDevice()) as draw:
        # clear the screen
        draw.rectangle(OLED.getDevice().bounding_box,
                       outline="black", fill="black")

        # display option for key "C"
        draw.text((5, 0), "Press ", fill="white")
        draw.text((40, 0), "C", fill="green")
        draw.text((50, 0), "to set", fill="white")
        draw.text((0, 10), "constant speed", fill="red")

        # display option for key "D"
        draw.text((5, 25), "Press", fill="white")
        draw.text((40, 25), "D", fill="green")
        draw.text((50, 25), "to set", fill="white")
        draw.text((0, 35), "run time", fill="red")

        # display some text
        draw.text((25, 45), "Exit", fill="yellow")
        draw.text((5, 52), "press any key", fill="yellow")
    return
